#version 330
#extension GL_EXT_gpu_shader4 : enable
//Infinite structures travelMod01.fsh by TambakoJaguar 
//https://www.shadertoy.com/view/3tcfWN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}
#define texture texture_Fract

/*
"Infinite mod structures" by Emmanuel Keller aka Tambako - February 2021
License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
Contact: tamby@tambako.ch

ToDo:
* Distortion X/Y axes
  * Camdir
  * Tilt scene when turning
    - tilt depends on spedfac (pow 2?)
* Sometimes intersections missing for a longer time or colors different (every nth)
  * Or sometimes only along path
* Crazy lights visible
* Correct bug screws
* Ambient occlusion
* speed variations
* Fog at times
  * Vary between blue gray and brown gray
  * Color also depends on the crazy lights colors (use showCrazyLights)
* Sometimes jump to the parallel lanes
* Rusty parts
* 180° tilt at a few times (smoothstep iTtime + mod)
* Tunnel at times
* More variations tiles
* Speed indicator at bottom of screen (gradient)
* Reflections (use different coefficients depending on object)
- Improve shadows?
- Improve abocc
* Add comments
- Try https://www.shadertoy.com/view/ws3Bzf

*/

#define pi 3.14159265359

// Switches, you can play with them!
#define specular              // Enables specular highlights of light sources on the surfaces
//#define shadow              // Enables shadows. Doesn't really look good :P
//#define ambocc              // Enables ambient occlusion. Doesn't really look good :P
#define plates                // Enables random colored plates
#define obliques              // Enables random oblique beams
#define intersections         // Enables the cubes and spheres at the beam's intersections
#define textures              // Enables the textures on the beams and plates
#define crazylights           // Enables two lights "dancing" in front of the camera and changing its color
#define showcrazylights       // Enables the display of the crazy lights as "orbs"
#define bumps                 // Enables the screws on the beams and other details as bumps (only for normal)
#define distortion            // Enables the distortion of the beams in the x and y axes, which is visible at times
#define fog                   // Enables the fog, visible at times
#define fognoise              // Enables noise in the fog, making it look like clouds
#define rust                  // Enables the rust on the beams, visible at times
#define tunnel                // Enables tunnels, visible at times
#define varspeed              // Enables variable speed of the camera
#define tilt                  // Enables tilting of the camera in curves, which is stonger when travelling faster
#define tilt180               // Enables the tilting of the view to 180° (upside down) at times
#define sidejumps             // Enables the jumping to parallel "lanes" on every 4 direction, at times
#define shaking               // Enables the shaking of the camera occuring at high speeds
#define speedindic            // Enables the speed indicator on the bottom of the screen
//#define keys                // Enables the key function: modification of the zoom factor and retrn in time
#define spy                   // Enables the appearance of the spy (UFO-like) at times
//#define spyglitches         // Enables the glitches on the appearance of the spy
//#define reflections         // Enables the reflections of the beams and spy

// Antialias. Change from 1 to 2 or more AT YOUR OWN RISK! It may CRASH your browser while compiling!
//#define antialias
const float aawidth = 0.65;
const int aasamples = 2;

// Ambient light
const vec3 ambientColor = vec3(1.);
const float ambientint = 0.0;

// Specular options
const float specint = 0.55;
const float specshin = 55.;

// Shadow options
const float shi = 0.5;
const float aoint = 0.5;

// Tracing options
const float normdelta = 0.0012;
const float maxdist = 100.;

// Color options
const float gamma = 1.4;
const vec3 structure_color1 = vec3(0.8, 0.8, 0.88);
const vec3 structure_color2 = vec3(0.78, 0.61, 0.45);
const vec3 tunnel_color1 = vec3(0.38, 0.57, 0.49);
const vec3 tunnel_color2 = vec3(0.28, 0.51, 0.38);
const vec3 tunnel_colord = vec3(0.39, 0.25, 0.21);
#ifdef reflections
const vec3 spy_color = vec3(0.88, 0.77, 0.72);
#else
const vec3 spy_color = vec3(0.64, 0.68, 0.75);
#endif

// Geometry options
const float ssize = 2.8;
const float structure_s1 = 0.12;
const float ws = 0.83;
const float ws2 = 0.05;
const float intscale = 0.85;
const float bumpheight = 0.004;
const float plth = 0.1;
const float spysize = 2.8;

// Fog
const vec3 fogColor1 = vec3(0.54, 0.63, 0.71);
const vec3 fogColor2 = vec3(0.71, 0.59, 0.51);
vec3 fogColor;
const float fogdens0 = 0.18;
float fogdensf;
float fogd;

// Campera options
vec3 campos = vec3(0., 0., 0.);
vec3 camtarget = vec3(0., 0., 0.);
vec3 camdir = vec3(0., 0., 0.);
float fov = 2.2;
float camspeed = 13.;
float camposdist = 1.8;
float camposint = 0.3;
float camtiltf = -0.58;
float camtilt;
const float shakeint = 0.0012;
const float axm = 2.*pi;
const float aym = 0.8;
float camtilt2;

float spindh = 0.027;

struct Lamp
{
  	vec3 position;
  	vec3 color;
  	float intensity;
  	float attenuation;
};

struct RenderData
{
  	vec3 col;
  	vec3 pos;
  	vec3 norm;
    float dist;
};
   
#ifdef crazylights
Lamp lamps[3];
#else
Lamp lamps[1];
#endif

// Misc variables definition
vec3 colors[9];
int aai;
int aaj;
float time2;
float speedfact;
float mainLampInt;
bool getSpy = true;
bool isSpy;
float spyBump;
float refFactor;
float tunnelse;

#ifdef keys
// Detects if keys are pressed
const float KEY_Z = 90.5/256.0;
const float KEY_U = 85.5/256.0;
const float KEY_H = 72.5/256.0;
const float KEY_J = 74.5/256.0;
const float KEY_N = 78.5/256.0;
const float KEY_M = 77.5/256.0;
const float KEY_1 = 49.5/256.0;
const float KEY_2 = 50.5/256.0;
const float KEY_3 = 51.5/256.0;
const float KEY_4 = 52.5/256.0;
const float KEY_5 = 53.5/256.0;
const float KEY_6 = 54.5/256.0;
const float KEY_7 = 55.5/256.0;
const float KEY_8 = 56.5/256.0;
const float KEY_9 = 57.5/256.0;
bool isKeyPressed(float key)
{
	return texture(iChannel3, vec2(key, 0.25) ).x > .0;
}
#endif

// Gets the virtual time, which enables a variable speed
float getTime(float time)
{
    //time2 = camspeed*(iTime + 158.);
    float time2 = camspeed*time;
    
    #ifdef keys
    // When pressing numeric keys, you can go back a different distance
    if (isKeyPressed(KEY_1)) time2-= 2.;
    if (isKeyPressed(KEY_2)) time2-= 5.;
    if (isKeyPressed(KEY_3)) time2-= 10.;
    if (isKeyPressed(KEY_4)) time2-= 20.;
    if (isKeyPressed(KEY_5)) time2-= 50.;
    if (isKeyPressed(KEY_6)) time2-= 100.;
    if (isKeyPressed(KEY_7)) time2-= 200.;
    if (isKeyPressed(KEY_8)) time2-= 500.;
    if (isKeyPressed(KEY_9)) time2-= 1000.;
    #endif
    
    #ifdef varspeed
    time2-= 58.*sin(time/9.) + 25.*cos(time/17.) - 12.*cos(time/5.7);
    #endif
    
    return time2;
}

// Initializes different things
void init()
{    
    // Lamps init
    lamps[0] = Lamp(vec3(0.5, 0., 0.), vec3(1., 1., 1.), 1.6, 0.03);
    #ifdef crazylights
    lamps[1] = Lamp(vec3(0.5, 0., 0.), vec3(1., 0., 0.), 2.8, 0.25);
    lamps[2] = Lamp(vec3(0.5, 0., 0.), vec3(1., 0., 0.), 2.8, 0.25);
    #endif
    
    // Colors of the plates
    colors[0] = vec3 (1., 0., 0.);
    colors[1] = vec3 (1., 1., 0.);
    colors[2] = vec3 (0., 1., 0.);
    colors[3] = vec3 (0., 1., 1.);
    colors[4] = vec3 (0., 0., 1.);
    colors[5] = vec3 (1., 0., 1.);
    colors[6] = vec3 (1., 0.65, 0.);
    colors[7] = vec3 (0.33);
    colors[8] = vec3 (0.67);
    
    // Gets the virtual time and calculates the travel speed
    time2 = getTime(iTime);
    speedfact = getTime(iTime+0.1) - getTime(iTime);
    
}

// RGB to HSV color conversion
vec3 hsv2rgb(vec3 c)
{
    vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
	rgb = rgb*rgb*(3.0-2.0*rgb);
	return c.z * mix( vec3(1.0), rgb, c.y);
}

// HSV to RGB color conversion
vec3 rgb2hsv(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

// 2D vector rotation
vec2 rotateVec(vec2 vect, float angle)
{
    vec2 rv;
    rv.x = vect.x*cos(angle) - vect.y*sin(angle);
    rv.y = vect.x*sin(angle) + vect.y*cos(angle);
    return rv;
}

// 1D hash function
float hash(vec3 p)
{
    //p  = 17.0*fract(p*0.3183099+.1);
	//return fract(p.x*p.y*p.z*(p.x+p.y+p.z));

    p  = 442.0*fract(p*0.3183099+.131249);
    return fract(dot(p.xyz, p.zxy));
    
	/*p  = fract(p * .1031);
    p += dot(p, p.zyx + 31.32);
    return fract((p.x + p.y) * p.z);  */
}

#ifdef fognoise
float noise(vec3 p)
{
	vec3 ip=floor(p);
    p-=ip; 
    vec3 s=vec3(7,157,113);
    vec4 h=vec4(0.,s.yz,s.y+s.z)+dot(ip.xyz,s);
    p=p*p*(3.-2.*p); 
    h=mix(fract(sin(h)*43758.5),fract(sin(h+s.x)*43758.5),p.x);
    h.xy=mix(h.xz,h.yw,p.y);
    return mix(h.x,h.y,p.z); 
}

const mat3 m = mat3( 0.00,  0.80,  0.60,
                    -0.80,  0.36, -0.48,
                    -0.60, -0.48,  0.64 );

// From https://www.shadertoy.com/view/4sfGzS
float noise2(vec3 pos)
{
    vec3 q = 8.0*pos;
    float f  = 0.5000*noise(q) ; q = m*q*2.01;
    f+= 0.2500*noise(q); q = m*q*2.02;
    f+= 0.1250*noise(q); q = m*q*2.03;
    f+= 0.0625*noise(q); q = m*q*2.01;
    return f;
}
#endif

// Distorts the whole structure with waves along the x and y axes for a cool effect!
vec3 distort(vec3 pos)
{
    #ifdef distortion
    float zfac = 0.85;
    float time3 = mod(time2, 1900.);
    float dint = 1.2*smoothstep(135., 370., time3)*smoothstep(790., 610., time3);
    dint+= 2.2*smoothstep(1050., 1290., time3)*smoothstep(1780., 1650., time3);
    if (dint>0.02)
    {
        pos.x+= 1.05*dint*(cos(zfac*pos.z*0.05) + 0.5*sin(zfac*pos.z*0.12) + 0.22*sin(zfac*pos.z*0.19) + 0.07*sin(zfac*pos.z*0.35));
        pos.y+= 0.85*dint*(sin(zfac*pos.z*0.05) + 0.5*cos(zfac*pos.z*0.14) + 0.18*sin(zfac*pos.z*0.18) + 0.09*sin(zfac*pos.z*0.32));
    }
    #endif
    return pos;
}

float smin( float a, float b, float k )
{
    float h = max(k-abs(a-b),0.0);
    return min(a, b) - h*h*0.25/k;
}

float sdTorus(vec3 p, vec2 t)
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

// Gets the bump (actually screws) which are only applied on the normal, not during the raymarching, for better speed
#ifdef bumps
float getNormalBump(vec3 pos)
{
    if (isSpy)
        return 0.;

    pos = distort(pos);

    float bump = 0.;
    vec3 pos2 = mod(pos, ssize);
    
    // Avoids to put screws on intersections!
    #ifdef intersections
    vec3 n = floor(pos/ssize);
    float ns = n.x+n.y+n.z;    
    float ints;
    float intprob = 0.77*(0.5 + 0.5*sin(-2.3 + n.z/73.)) + 0.17*(0.5 + 0.5*sin(0.84 + n.z/23.)) + 0.06*(0.5 + 0.5*sin(n.z/11.5));
    if ((intprob<0.85 || (intprob<0.92 && (n.x==-1. || n.x==0.) && (n.y==-1. || n.y==0.))) && hash(n*571.6518)>0.026)
    {    
        if (mod(ns, 2.)==1.)
           ints = length(pos2-vec3(0.5*ssize))-structure_s1*2.*intscale;
        else
           ints = max(max(abs(pos2.x-0.5*ssize)-structure_s1*1.5*intscale, abs(pos2.y-0.5*ssize)-structure_s1*1.5*intscale), abs(pos2.z-0.5*ssize)-structure_s1*1.5*intscale);
        if (ints<bumpheight)
            return 0.;
    }
    #endif
    
    // Avoids to put screws on plates!
    vec3 n2;
    vec3 n3;
    #ifdef plates
    n2 = floor(pos/ssize-vec3(0., 0.5, 0.5));
    n3 = floor(pos/ssize-vec3(0.5, 0., 0.5));
    float platesprob = 0.3*(1.-cos(n2.z/75.)) + 0.07*(1.-cos(n2.z/16.));
    float wx = max(abs(pos2.x-0.5*ssize)-structure_s1*plth, max(1.-abs(pos2.y-0.5*ssize)-ws, 1.-abs(pos2.z-0.5*ssize)-ws));
    float wy = max(abs(pos2.y-0.5*ssize)-structure_s1*plth, max(1.-abs(pos2.x-0.5*ssize)-ws, 1.-abs(pos2.z-0.5*ssize)-ws));
    if (hash(n2*752.56258)<platesprob && wx<bumpheight)
       return 1.8*texture(iChannel1, 0.25*pos.yz).r;
    if (hash(n3*842.84329)<platesprob && wy<bumpheight)
       return 1.8*texture(iChannel1, 0.25*pos.xz).r;       
    #endif

    float tx = abs(pos2.x-0.5*ssize)-structure_s1*0.5;
    float ty = abs(pos2.y-0.5*ssize)-structure_s1*0.5;
    float tz = abs(pos2.z-0.5*ssize)-structure_s1*0.5;
    
    float bz = max(tx, ty);
    float by = max(tx, tz);
    float bx = max(ty, tz);
    
    vec3 posb = mod(100.*pos2/ssize, 1.);
    n3 = 100.*pos2/ssize;
    
    float scs = 15.;
    
    // Screws on perpendicular beams
    if (bz<=bumpheight)
    {
        bump = (int(n3.x)==51 || int(n3.x)==48)?(-sqrt(clamp(1. - scs*pow(posb.x - 0.5, 2.) - scs*pow(posb.z - 0.5, 2.), 0., 1.))):0.;
        bump+= (int(n3.y)==51 || int(n3.y)==48)?(-sqrt(clamp(1. - scs*pow(posb.y - 0.5, 2.) - scs*pow(posb.z - 0.5, 2.), 0., 1.))):0.;
    }
    if (bx<=bumpheight)
    {
        bump = (int(n3.z)==51 || int(n3.z)==48)?(-sqrt(clamp(1. - scs*pow(posb.x - 0.5, 2.) - scs*pow(posb.z - 0.5, 2.), 0., 1.))):0.;
        bump+= (int(n3.y)==51 || int(n3.y)==48)?(-sqrt(clamp(1. - scs*pow(posb.x - 0.5, 2.) - scs*pow(posb.y - 0.5, 2.), 0., 1.))):0.;
    } 
    if (by<=bumpheight)
    {
        bump = (int(n3.x)==51 || int(n3.x)==48)?(-sqrt(clamp(1. - scs*pow(posb.x - 0.5, 2.) - scs*pow(posb.y - 0.5, 2.), 0., 1.))):0.;
        bump+= (int(n3.z)==51 || int(n3.z)==48)?(-sqrt(clamp(1. - scs*pow(posb.z - 0.5, 2.) - scs*pow(posb.y - 0.5, 2.), 0., 1.))):0.;
    }
    
    // Screws on oblique beams
    #ifdef obliques
    vec3 pos3 = mod(pos+ssize*(0., 0.5, 0.5), ssize);
    vec3 pos4 = mod(pos+ssize*(0.5, 0., 0.5), ssize);
    float tyz2 = abs(pos3.y+pos3.z-ssize)-structure_s1*0.5;
    float tyz3 = abs(pos3.y-pos3.z)-structure_s1*0.5;     
    float txz2 = abs(pos4.x+pos4.z-ssize)-structure_s1*0.5;
    float txz3 = abs(pos4.x-pos4.z)-structure_s1*0.5;     
    float bz2 = max(tx, tyz2);
    float bz3 = max(tx, tyz3);
    float by2 = max(ty, txz2);
    float by3 = max(ty, txz3); 
    
    if (by2<=bumpheight && by3>bumpheight)
    {
        bump = (int(n3.y)==51 || int(n3.y)==48)?(-sqrt(clamp(1. - scs*pow(posb.y - 0.5, 2.) - scs*pow(1.414*posb.z - 0.5, 2.), 0., 1.))):0.;
        bump+= (int(n3.x+n3.z)==98 || int(n3.x+n3.z)==101)?(-sqrt(clamp(1. - scs*pow(posb.x - 0.25, 2.) - scs*pow(posb.z- 0.25, 2.), 0., 1.))):0.;
    } 
    else if (by3<=bumpheight && by2>bumpheight)
    {
        bump = (int(n3.y)==51 || int(n3.y)==48)?(-sqrt(clamp(1. - scs*pow(posb.y - 0.5, 2.) - scs*pow(1.414*posb.z - 0.5, 2.), 0., 1.))):0.;
        bump+= (int(-n3.x+n3.z)==1 || int(-n3.x+n3.z)==-1)?(-sqrt(clamp(1. - scs*pow(posb.x - 0.75, 2.) - scs*pow(posb.z - 0.35, 2.), 0., 1.))):0.;
    }
    else if (bz2<=bumpheight && bz3>bumpheight)
    {
        bump = (int(n3.x)==51 || int(n3.x)==48)?(-sqrt(clamp(1. - scs*pow(posb.x - 0.5, 2.) - scs*pow(1.414*posb.z - 0.5, 2.), 0., 1.))):0.;
        bump+= (int(n3.y+n3.z)==98 || int(n3.y+n3.z)==101)?(-sqrt(clamp(1. - scs*pow(posb.y - 0.25, 2.) - scs*pow(posb.z- 0.25, 2.), 0., 1.))):0.;
    } 
    else if (bz3<=bumpheight && bz2>bumpheight)
    {
        bump = (int(n3.x)==51 || int(n3.x)==48)?(-sqrt(clamp(1. - scs*pow(posb.x - 0.5, 2.) - scs*pow(1.414*posb.z - 0.5, 2.), 0., 1.))):0.;
        bump+= (int(-n3.y+n3.z)==1 || int(-n3.y+n3.z)==-1)?(-sqrt(clamp(1. - scs*pow(posb.y - 0.75, 2.) - scs*pow(posb.z- 0.35, 2.), 0., 1.))):0.;
    }     
    #endif    
        
    return bump;
}
#endif

// Maps the spy
#ifdef spy
vec3 spypos;
float map_spy(vec3 pos)
{
    float zpos = -1000.*(smoothstep(85., 65., mod(iTime, 280.)) - smoothstep(120., 140., mod(iTime, 280.)));
    //float zpos = -700.*(smoothstep(15., -5., mod(iTime, 280.)) - smoothstep(120., 140., mod(iTime, 280.)));
    if (abs(zpos)>maxdist)
        return maxdist;
    
    pos.z-= -time2 -7.8 - zpos;
    pos.x+= 0.09*sin(time2*0.17 + 1.);
    pos.y+= 0.13*sin(iTime*2.5);
    pos.z+= 1.2*sin(time2*1.34/camspeed) + 0.52*sin(time2*0.58/camspeed);
    pos.y*= 1.27;
    
    spypos = pos;
    spypos.x+= 0.09*sin(time2*0.07 + 1.);
    spypos.y+= 0.13*sin(iTime*2.5);
    spypos.z+= 0.2*sin(iTime*1.23);  
    
    float spyo = length(pos) - 0.26*spysize;
    
    // Adds a torus
    spyo = smin(spyo, sdTorus(pos, spysize*vec2(0.25, 0.05)), spysize*0.02);
    
    // Adds a structure
    float a = atan(pos.x, pos.z) + iTime*0.5;
    spyBump = .0037*smoothstep(0.88, 0.72, sin(a*24.))*smoothstep(0.15*spysize, 0.145*spysize, abs(pos.y));
    spyBump-= 0.0037*smoothstep(0.165*spysize, 0.160*spysize, abs(pos.y));
    spyo+= spyBump;
    
    return spyo;
}
#endif

// Maps the tunnel on sometimes travels through
#ifdef tunnel
float map_tunnel(vec3 pos)
{   
    float tunnelo = length(pos.xy) - ssize*0.46;
    float posz = -mod(-pos.z, 3300.);
    
    vec3 pos2 = pos;
    pos2.z = mod(posz, ssize) - ssize*0.3;
    
    // Side openings
    float tunnelf = -length(pos2.yz) + ssize*0.2;
    tunnelo = max(tunnelo, tunnelf);    
    
    // Inside with waves
    tunnelo = max(tunnelo, -length(pos.xy) + ssize*0.447 + 0.008*abs(sin(posz*15.))*smoothstep(-0.032, -0.042, tunnelf));
    
    // Where there is the tunnel, where not
    // Already calculated in map()
    //float tunnelse = smoothstep(-604., -602., posz) + smoothstep(-830., -832., posz) - 0.002;
    //tunnelse*= smoothstep(-2053., -2051., posz) + smoothstep(-2260.5, -2262.5, posz) - 0.002;
    //tunnelse*= smoothstep(-2932.2, -2930.2, posz) + smoothstep(-2979.7, -2981.7, posz) - 0.002;
    tunnelo = max(tunnelo, tunnelse);
    
    return tunnelo;
}
#endif

// Main mapping function
float map(vec3 pos)
{
    pos = distort(pos);

    #ifdef spy
    float spyo;
    if (getSpy)
        spyo = map_spy(pos);
    #endif
    
    // The perpendicular beams
    vec3 pos2 = mod(pos, ssize);
    
    float tx = abs(pos2.x-0.5*ssize)-structure_s1*0.5;
    float ty = abs(pos2.y-0.5*ssize)-structure_s1*0.5;
    float tz = abs(pos2.z-0.5*ssize)-structure_s1*0.5;
    
    float bz = max(tx, ty);
    float by = max(tx, tz);
    float bx = max(ty, tz);
    
    float str = min(bx, min(by, bz));  
    
    // The intersections (alternatively spheres and cubes)
    #ifdef intersections
    vec3 n = floor(pos/ssize);
    float intprob = 0.77*(0.5 + 0.5*sin(-2.3 + n.z/73.)) + 0.17*(0.5 + 0.5*sin(0.84 + n.z/23.)) + 0.06*(0.5 + 0.5*sin(n.z/11.5));
    if ((intprob<0.85 || (intprob<0.92 && (n.x==-1. || n.x==0.) && (n.y==-1. || n.y==0.))) && hash(n*571.6518)>0.026)
    {
        float ns = n.x+n.y+n.z;
        if (mod(ns, 2.)==1.)
           str = min(str, length(pos2-vec3(0.5*ssize))-structure_s1*2.*intscale);
        else
           str = min(str, max(max(abs(pos2.x-0.5*ssize)-structure_s1*1.5*intscale, abs(pos2.y-0.5*ssize)-structure_s1*1.5*intscale), abs(pos2.z-0.5*ssize)-structure_s1*1.5*intscale));
    }
    #endif
    
    // The colored plates!
    #ifdef plates
    vec3 n2 = floor(pos/ssize-vec3(0., 0.5, 0.5));
    vec3 n3 = floor(pos/ssize-vec3(0.5, 0., 0.5));
    
    // How often the plates should come, depends on the travel path
    float platesprob = 0.3*(1.-cos(n2.z/75.)) + 0.07*(1.-cos(n2.z/16.));
    
    // Adds the plates
    if (hash(n2*752.56258)<platesprob)
    {
        // Vertical
        float wx = max(abs(pos2.x-0.5*ssize)-structure_s1*plth, max(1.-abs(pos2.y-0.5*ssize)-ws, 1.-abs(pos2.z-0.5*ssize)-ws));
    
        // Sometimes there are 4 square holes in the plate (vertical plates)
        if (hash(n2*829.7685)<0.15)
        {
            float wxh = max(abs(pos2.x-0.5*ssize)-structure_s1*(plth+0.02), max(1.-abs(mod(2.*pos2.y+0.8, ssize))+0.65, 1.-abs(mod(2.*pos2.z+0.8, ssize))+0.65));
            wx = max(wx, -wxh);
        }
        // Or only one bigger square hole...
        else if (hash(n3*843.4276)<0.032)
        {
            float wxh2 = max(abs(pos2.x-0.5*ssize)-structure_s1*(plth+0.02), max(1.-abs(pos2.x-0.5*ssize)-ws*0.23, 1.-abs(pos2.z-0.5*ssize)-ws*0.23));
            wx = max(wx, -wxh2);    
        }      
    
        str = min(str, wx);
    }
    else
    {
    #endif
    #ifdef obliques
        // Adds oblique beams, but not when there are plates
        vec3 pos3 = mod(pos+ssize*(0., 0.5, 0.5), ssize);
        float bz2prob = 0.45*(1.-0.7*cos((n2.z+5.)/85.)-0.3*cos((n2.z-4.)/40.));
        float bz3prob = 0.45*(1.-0.7*cos((n2.z+8.)/65.)-0.3*cos((n2.z+5.)/125.));
        if (hash(n2*462.14823)<bz2prob)
        {
            float tyz2 = abs(pos3.y+pos3.z-ssize)-structure_s1*0.5;
            float bz2 = max(tx, tyz2);
            str = min(str, bz2);
        }
        if (hash(n2*576.17496)<bz3prob)
        {
            float tyz3 = abs(pos3.y-pos3.z)-structure_s1*0.5; 
            float bz3 = max(tx, tyz3);
            str = min(str, bz3);
         }
    #endif
    #ifdef plates
    }
    if (hash(n3*842.84329)<platesprob)
    {
        // Horizontal
        float wy = max(abs(pos2.y-0.5*ssize)-structure_s1*plth, max(1.-abs(pos2.x-0.5*ssize)-ws, 1.-abs(pos2.z-0.5*ssize)-ws));    
    
        // Sometimes there are 4 square holes in the plate (horizontal plates)
        if (hash(n3*134.7126)<0.15)
        {
            float wyh = max(abs(pos2.y-0.5*ssize)-structure_s1*(plth+0.02), max(1.-abs(mod(2.*pos2.x+0.8, ssize))+0.65, 1.-abs(mod(2.*pos2.z+0.8, ssize))+0.65));
            wy = max(wy, -wyh);
        }
        // Or only one bigger square hole...
        else if (hash(n3*843.4276)<0.028)
        {
            float wyh2 = max(abs(pos2.y-0.5*ssize)-structure_s1*(plth+0.02), max(1.-abs(pos2.x-0.5*ssize)-ws*0.23, 1.-abs(pos2.z-0.5*ssize)-ws*0.23));
            wy = max(wy, -wyh2);    
        }      
        str = min(str, wy);
    }
    else
    {
    #endif
    #ifdef obliques
        // Adds oblique beams, but not when there are plates
        vec3 pos4 = mod(pos+ssize*(0.5, 0., 0.5), ssize);
        float by2prob = 0.45*(1.-0.7*cos((n3.z+12.)/80.)-0.3*cos((n3.z-7.)/65.));
        float by3prob = 0.45*(1.-0.7*cos((n3.z+15.)/35.)-0.3*cos((n3.z-12.)/105.));        
        if (hash(n3*127.6359)<by2prob)
        {
            float txz2 = abs(pos4.x+pos4.z-ssize)-structure_s1*0.5;
            float by2 = max(ty, txz2);
            str = min(str, by2);
        }
        if (hash(n3*319.5628)<by3prob)
        {
            float txz3 = abs(pos4.x-pos4.z)-structure_s1*0.5; 
            float by3 = max(ty, txz3);
            str = min(str, by3);
        }
    #endif
    #ifdef plates
    }
    
    // Adds the facing plates with holes, but not in the tunnel
    float posz = -mod(-pos.z, 3300.);
    tunnelse = smoothstep(-605., -603., posz) + smoothstep(-830., -832., posz) - 0.002;
    tunnelse*= smoothstep(-2053., -2051., posz) + smoothstep(-2260.5, -2262.5, posz) - 0.002;
    tunnelse*= smoothstep(-2932.2, -2930.2, posz) + smoothstep(-2979.7, -2981.7, posz) - 0.002;    
    
    vec3 n4 = floor(pos/ssize-vec3(0.5, 0.5, 0.5));
    if (hash(n4*184.567)<platesprob*0.1 && n4.x==-1. && n4.y==-1. && tunnelse>0.)
    {
        // Plates on the path facing the camera, with a hole in it
        float wz = max(abs(pos2.z-0.5*ssize)-structure_s1*plth, max(1.-abs(pos2.x-0.5*ssize)-ws, 1.-abs(pos2.y-0.5*ssize)-ws));
        wz = max(wz, -length(pos.xy) + ssize*0.34);    
    
        str = min(str, wz);    
    }
    #endif
    
    // Adds the spy
    #ifdef spy
    if (getSpy)
        str = min(str, spyo);
    #endif    
    
    // Adds the tunnel
    #ifdef tunnel
    if (tunnelse<0.4)
    {
        float tunnelo = map_tunnel(pos);
        str = min(str, tunnelo);
    }
    #endif
    
    return str;
}

// Main tracing function
float trace(vec3 cam, vec3 ray, float maxdist) 
{
    float t = 0.1;
    float objnr = 0.;
    vec3 pos;
    float dist;
    
  	for (int i = 0; i < 145; ++i)
    {
    	pos = ray*t + cam;
        dist = map(pos);
        if (t>maxdist || abs(dist)<0.0002)
            break;
        t+= dist*0.86;
  	}
  	return t;
}

// Simpler tracing function for crazy lights
#ifdef showcrazylights
float tracel(vec3 cam, vec3 ray, float maxdist) 
{
    float t = 1.2;
    float objnr = 0.;
    vec3 pos;
    float dist;
    
  	for (int i = 0; i < 25; ++i)
    {
    	pos = ray*t + cam;
        dist = map(pos);
        if (t>maxdist || abs(dist)<0.0002)
            break;
        t+= dist*1.2;
  	}
  	return t;
}
#endif

// Gets the normal
vec3 getNormal(vec3 pos, float e)
{  
    vec3 n = vec3(0.0);
    for( int i=0; i<4; i++ )
    {
        vec3 e2 = 0.5773*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        // Adds the bumps (screws)
        #ifdef bumps
        n += e2*(map(pos + e*e2)+bumpheight*getNormalBump(pos + e*e2));
        #else
        n += e2*(map(pos + e*e2));
        #endif
    }
    return normalize(n);
}

// Calculates a soft shadow
#ifdef shadow
float calcSoftshadow(in vec3 ro, in vec3 rd)
{
    float res = 1.0;
    float tmax = 12.0;  
    
    float t = 0.02;
    for( int i=0; i<40; i++ )
    {
		float h = map(ro + rd*t);
        res = min( res, 24.0*h/t );
        t += clamp( h, 0.0, 0.80 );
        if( res<0.005 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}
#endif

// Combines the colors
vec3 getColor(vec3 norm, vec3 pos, vec3 ray)
{ 
    vec3 pos0 = pos;
    pos = distort(pos);
    refFactor = 0.;
    
    // Spy coplor
    isSpy = false;
    #ifdef spy
    if (map_spy(pos)<0.002)
    {
        isSpy = true;
        refFactor = 0.71;
        return mix(spy_color, 1.4*spy_color*texture(iChannel0, 0.8*(pos.xy+spypos.xy)/spysize).rgb, 0.6)*smoothstep(-0.015, 0., spyBump)*mix(vec3(0.98, 0.72, 0.65), vec3(1.), smoothstep(0., 0.24*spysize, abs(pos.y+spypos.y)));
    }
    #endif    
    
    // Tunnel color
    #ifdef tunnel
    if (map_tunnel(pos)<0.001)
    {
        float tl = -length(pos.xy) + ssize*0.417;
        vec3 tcol = mix(tunnel_color1, tunnel_color2, smoothstep(0., -0.008, tl));
        
        // Changes the color a bit over the path
        vec3 tcolhsv = rgb2hsv(tcol);
        tcolhsv.x = mod(tcolhsv.x - pos.z*.00012 - 0.08, 1.);
        tcol = hsv2rgb(tcolhsv);
        
        // Adds dirt
        float td1 = texture(iChannel1, 0.3*rotateVec(pos.xz, 1.)).r;
        float td2 = texture(iChannel1, 0.6*rotateVec(pos.xz, 1.4)).g;
        float td3 = texture(iChannel1, 1.3*rotateVec(pos.xz, 2.25)).b;
        float td = 0.45*td1 + 0.35*td2 + 0.2*td3;
        float dpos = smoothstep(-ssize*0.47, 0., pos.y + 0.07*cos(pos.z*0.8));
        tcol = mix(tcol, tunnel_colord*smoothstep(dpos + 0.95, dpos + 0.47, td), 0.8*smoothstep(dpos, dpos + 0.62, td));
        
        return tcol;
    }
    #endif

    vec3 pos2 = mod(pos, ssize);

    vec3 n = floor(pos/ssize);
    float ns = n.x+n.y+n.z;    
    vec3 n2 = floor(pos/ssize-vec3(0., 0.5, 0.5));
    vec3 n3 = floor(pos/ssize-vec3(0.5, 0., 0.5));
    
    float scolorprob = 0.7*(0.5+0.5*sin(0.35 + n.z/50.)) + 0.16*(0.5+0.5*sin(n.z/16.)) + 0.14*(0.5+0.5*sin(n.z/4.67));
    
    // Colorizes the intersections
    #ifdef intersections
    float intprob = 0.77*(0.5 + 0.5*sin(-2.3 + n.z/73.)) + 0.17*(0.5 + 0.5*sin(0.84 + n.z/23.)) + 0.06*(0.5 + 0.5*sin(n.z/11.5));
    if ((intprob<0.85 || (intprob<0.92 && (n.x==-1. || n.x==0.) && (n.y==-1. || n.y==0.))) && hash(n*571.6518)>0.026)
    {    
        if (mod(ns, 2.)==1.)
        {
           if (length(pos2-vec3(0.5*ssize))-structure_s1*2.*intscale<0.0008)
               return scolorprob<0.21?0.8*structure_color1:(hash(n*2.8436)>0.986?vec3(1., 0.03, 0.23):vec3(0.8, 0.65, 0.4));
        }
        else
        {
            if (max(max(abs(pos2.x-0.5*ssize)-structure_s1*1.5*intscale, abs(pos2.y-0.5*ssize)-structure_s1*1.5*intscale), abs(pos2.z-0.5*ssize)-structure_s1*1.5*intscale)<0.0008)
                return vec3(0.5, 0.6, 0.7);
        }
    }
    #endif
    
    // Colorizes the plates using one of the 6 predefined colors
    #ifdef plates
    // Vertical
    float wx = max(abs(pos2.x-0.5*ssize)-structure_s1*plth, max(1.-abs(pos2.y-0.5*ssize)-ws, 1.-abs(pos2.z-0.5*ssize)-ws));
    // Horizontal
    float wy = max(abs(pos2.y-0.5*ssize)-structure_s1*plth, max(1.-abs(pos2.x-0.5*ssize)-ws, 1.-abs(pos2.z-0.5*ssize)-ws));
    // Plates on the path facing the camera, with a hole in it
    float wz = max(abs(pos2.z-0.5*ssize)-structure_s1*plth, max(1.-abs(pos2.x-0.5*ssize)-ws, 1.-abs(pos2.y-0.5*ssize)-ws));
    float platesprob = 0.3*(1.-cos(n2.z/75.)) + 0.07*(1.-cos(n2.z/16.));
    
    // Vertical
    if (wx<0.01 && hash(n2*752.56258)<platesprob)
    {
        vec3 col = colors[int(7.*hash(n2*54.251))];
        float h = hash(n2*42.519);
        if (h<0.04)
            col = colors[7];
        if (h>0.96)
            col = colors[8];        
        #ifdef textures
        float mc = texture(iChannel1, 0.3*vec2(pos.y, pos.z)).r;
        return col*(0.7+0.3*mc);
        #else
        return col;
        #endif
        
    }
    // Horizontal
    else if (wy<0.01 && hash(n3*842.84329)<platesprob)
    {
        vec3 col = colors[int(7.*hash(n3*71.849))];
        float h = hash(n3*39.758);
        if (h<0.04)
            col = colors[7];
        if (h>0.96)
            col = colors[8];            
        #ifdef textures
        float mc = texture(iChannel1, 0.3*vec2(pos.x, pos.z)).r;
        return col*(0.7+0.3*mc);
        #else
        return col;
        #endif        
    }
    // Plates on the path facing the camera, with a hole in it
    else if (wz<0.01)
    {
        vec3 n4 = floor(pos/ssize-vec3(0.5, 0.5, 0.5));
        if (hash(n4*184.567)<platesprob*0.1 && n4.x==-1. && n4.y==-1.)
        {
            vec3 col = colors[int(7.*hash(n4*71.849))];
            #ifdef textures
            float mc = texture(iChannel1, 0.3*vec2(pos.x, pos.y)).r;
            return col*(0.7+0.3*mc);
            #else
            return col;
            #endif             
        }
    }
    else
    {
    #endif
        // Sometimes the structure has a different color
        vec3 scolor = scolorprob<0.21?structure_color2:structure_color1;
        
        // Makes the screws darker and browner
        #ifdef bumps
        float bmp = getNormalBump(pos0);
        if (bmp<0.)
            scolor = mix(vec3(0.5, 0.32, 0.23), scolor, 0.45);
        #endif
        
        // So that the textures are correct on the different angles of the beams
        #ifdef textures
        vec2 tpos;
        if (abs(norm.x)>0.9 && abs(norm.y)<0.1 && abs(norm.z)<0.1)
            tpos = vec2(pos.y, pos.z + 1.2);
        if (abs(norm.x)<0.1 && abs(norm.y)>0.9 && abs(norm.z)<0.1)
            tpos = vec2(pos.x, pos.z);
        if (abs(norm.x)<0.1 && abs(norm.y)<0.1 && abs(norm.z)>0.9)
            tpos = vec2(pos.x+ 0.6, pos.y);
        if (abs(norm.x)<0.1 && abs(norm.y)>0.45 && abs(norm.z)>0.45)
            tpos = vec2(pos.x, 1.41*pos.y);
        if (abs(norm.x)>0.45 && abs(norm.y)<0.1 && abs(norm.z)>0.45)
            tpos = vec2(1.41*pos.z, pos.y);              
        vec3 mc = texture(iChannel0, 0.2*tpos).rgb;
        scolor = mix(scolor, mc, 0.34);
        
        refFactor = 0.18;
        
        // At some portions of the path, the beams are rusty!
        #ifdef rust
        float rustpos = (0.39 + smoothstep(40., 30., iTime) + clamp(0.48*sin(pos.z*0.054) + 0.09*sin(pos.z*0.0298) + 0.1*sin(pos.z*0.0527) + 0.635, 0., 0.6));
        if (rustpos<0.9)
        {
            vec3 n4 = floor(pos/ssize-vec3(0.5 + structure_s1*0.6, 0.5 + structure_s1*0.6, 0.5 + structure_s1*0.6));
            float rustsize = 0.4 + 1.7*hash(n4*174.1796);
            float rustrot = 2.*pi*hash(n4*749.5723);
            vec2 rustoffset = 94.74*vec2(hash(n4*857.236), hash(n4*457.128));
            tpos = rotateVec(tpos, rustrot)+ rustoffset;
            vec3 mcr = texture(iChannel0, rustsize*1.1*tpos).rgb;
            vec3 mcr2 = texture(iChannel1, rustsize*2.1*tpos).rgb;
            vec3 rustcolor = (0.8 + 0.2*smoothstep(rustpos + 0.02, rustpos + 0.04, 0.6*mcr.r + 0.4*mcr))*mix(vec3(0.43, 0.27, 0.12), vec3(0.84, 0.49, 0.12), 0.5*clamp(6.*mcr2.r - 2.5, 0., 1.) + 0.5*smoothstep(rustpos + 0.02, rustpos + 0.4*(1. - rustpos), mcr.r));
            float rustFactor = smoothstep(rustpos, rustpos + 0.02, mcr.r);
            scolor = mix(scolor, rustcolor, rustFactor);
            refFactor*= 1. - rustFactor;
        }
        #endif
        #endif
        
        return scolor;        
    #ifdef plates
    }
    #endif
}

// Shading of the objects pro lamp
vec3 lampShading(Lamp lamp, vec3 norm, vec3 pos, vec3 ocol, int lampnr)
{   
    float lampint = lamp.intensity;
    vec3 lampcolor = lamp.color;
    #ifdef crazylights
    float lint = smoothstep(30., 180., time2);
    if (lampnr==0)
    {
        // Changes the intensity of the main (camera) lamp with time
        mainLampInt = 1. -lint + lint*clamp(0.25 + (1. + 1.15*sin(time2*0.018) + 0.215*sin(time2*0.104) + 0.033*sin(time2*0.248)), 0., 1.);
        lampint*= mainLampInt;
        lamps[0].intensity = lampint;
    }
    if (lampnr==1)
    {
        // Changes the intensity and color of the first crazy lamp with time
        lampint*= lint*(1. + 0.33*sin(time2*0.035));
        lampcolor = hsv2rgb(vec3(0.5+0.5*cos(time2*0.015), 1., 1.));
        lamps[1].intensity = lampint;
        lamps[1].color = lampcolor;
    }
    if (lampnr==2)
    {
        // Changes the intensity and color of the first crazy lamp with time
        lampint*= lint*(1. + 0.33*sin(time2*0.043));
        lampcolor = hsv2rgb(vec3(1.+0.5*cos(time2*0.015), 1., 1.));
        lamps[2].intensity = lampint;
        lamps[2].color = lampcolor;       
    }
    #else
    mainLampInt = 1.;
    #endif

    vec3 lamppos;
    if (lampnr==0)
        // Sets the position of the main (camera) lamp
        lamppos = campos - vec3(pos.x*0.15, pos.y*0.6 - 0.6, 0.8);
    #ifdef crazylights
    if (lampnr==1)
    {
        // The position variation of the first crazy lamp with time
        float lpx = 5.5*sin(time2*0.15) + 1.5*sin(time2*0.65) + 0.71*sin(time2*1.05);
        float lpy = 4.2*sin(time2*0.11) + 1.2*sin(time2*0.55) + 0.65*sin(time2*0.95);
        float lpz = 5.8*sin(time2*0.18) + 1.9*sin(time2*0.45) + 0.92*sin(time2*1.35) + 8.5;
        lamppos = campos - vec3(lpx, lpy, lpz);
        lamps[1].position = lamppos;
    }
    if (lampnr==2)
    {
        // The position variation of the second crazy lamp with time
        float lpx = 3.8*sin(time2*0.09 + 3.) + 1.3*sin(time2*0.48) + 0.48*sin(time2*1.12);
        float lpy = 4.7*sin(time2*0.13 + 2.) + 1.6*sin(time2*0.59) + 0.71*sin(time2*1.03);
        float lpz = 6.2*sin(time2*0.20 + 1.) + 1.8*sin(time2*0.38) + 0.88*sin(time2*1.28) + 8.5;
        lamppos = campos - vec3(lpx, lpy, lpz);
        lamps[2].position = lamppos;
    }
    #endif
    vec3 pl = normalize(lamppos - pos);
    float dlp = distance(lamppos, pos);
    float dnp = (0.2+0.8*dot(norm, pl))/pow(1. + lamp.attenuation*dlp, 2.);
      
    // Diffuse shading
    vec3 col = ocol*lampcolor*lampint*smoothstep(-0.1, 1., dnp); //clamp(dnp, 0., 1.);
    
    // Specular shading
    #ifdef specular
    if (dot(norm, lamppos - pos) > 0.0)
        col+= lampcolor*lampint*specint*pow(max(0.0, dot(reflect(pl, norm), normalize(pos - lamppos))), specshin)/pow(1. + lamp.attenuation*dlp, 2.);
    #endif
    
    // Softshadow
    #ifdef shadow
    col*= shi*calcSoftshadow(pos, pl) + 1. - shi;
    #endif
    
    return col;
}

// Shading of the objects over all lamps
vec3 lampsShading(vec3 norm, vec3 pos, vec3 ocol)
{
    vec3 col = vec3(0.);
    for (int l=0; l<lamps.length(); l++)
        col+= lampShading(lamps[l], norm, pos, ocol, l);
    
    return col;
}

#ifdef showcrazylights
// This functions shows the crazy lamps as a kind of orb (using specular like dot function)
vec3 showCrazyLights(vec3 camPos, vec3 ray, vec3 lampPos, float lampInt, vec3 lampCol)
{
    float ld = distance(lampPos, camPos);
    float lvint = (0.7 + 0.7/ld)*lampInt*pow(clamp(dot(normalize(lampPos - camPos), ray), 0., 1.), ld*3000.);
    if (lvint>0.06)
    {
        // Doesn't show the lamps when they are hidden behind an object
        float tx = tracel(camPos, ray, ld+0.1);
        if (ld<tx)
        {
            return mix(lampCol, vec3(1.), 0.37)*lvint;
        }
        else
            return vec3(0.);
    }
    else
        return vec3(0.);    
}
#endif

// Gets the color of the fog depending on the position and ray direction
vec3 getFogColor(vec3 camPos, vec3 ray)
{
    // Varies over time between two defined fog colors
    float fcfac = 0.5 + 0.32*sin(time2*0.015) + 0.13*sin(time2*0.037) + 0.05*sin(time2*0.066);
    vec3 fogcol = mix(fogColor1, fogColor2, fcfac)*(0.15 + 0.85*fogdensf);
    
    // This changes the color of the fog accordingly to the crazy lights, for a... crazy effect!
    #ifdef crazylights
    float ld1 = distance(lamps[1].position, camPos);
    float ld2 = distance(lamps[2].position, camPos);
    float lvint1 = (1. - 0.8*mainLampInt)*(0.7 + 0.7/ld1*ld1)*lamps[1].intensity*pow(clamp(dot(normalize(lamps[1].position - camPos), ray), 0., 1.), 6.6/pow(fogdensf, 2.));    
    float lvint2 = (1. - 0.8*mainLampInt)*(0.7 + 0.7/ld2*ld2)*lamps[2].intensity*pow(clamp(dot(normalize(lamps[2].position - camPos), ray), 0., 1.), 6.6/pow(fogdensf, 2.));
    
    fogcol+= 0.1*mix(lamps[1].color, vec3(1.), 0.37)*lvint1;
    fogcol+= 0.1*mix(lamps[2].color, vec3(1.), 0.37)*lvint2;
    #endif
    
    return fogcol;
}

// Ambient occlusion
// From https://www.shadertoy.com/view/Xds3zN
#ifdef ambocc
float calcAO(in vec3 pos, in vec3 nor)
{
	float occ = 0.0;
    float sca = 1.0;
    for(int i=0; i<9; i++)
    {
        float hr = 0.012 + 0.045*float(i);
        vec3 aopos =  nor*hr + pos;
        float dd = map(aopos);
        occ+= clamp(-(dd - hr)*sca, 0.007, 0.2);
        sca*= 0.55;
    }
    occ = 2.*smoothstep(0.06, 0.5, occ);
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 );    
}
#endif

// From https://www.shadertoy.com/view/lsSXzD, modified
vec3 GetCameraRayDir(vec2 vWindow, vec3 vCameraDir, float fov)
{
	vec3 vForward = normalize(vCameraDir);
	vec3 vRight = normalize(cross(vec3(0.0, 1.0, 0.0), vForward));
	vec3 vUp = normalize(cross(vForward, vRight));
    
	vec3 vDir = normalize(vWindow.x * vRight + vWindow.y * vUp + vForward * fov);

	return vDir;
}

// Sets the position of the camera with the mouse and calculates its direction
void setCamera()
{
    // Travel position
    campos.z = -time2;
    campos = distort(campos);
    campos.xy*= -1.;
    
    // At high speeds, the camera is shaking!
    #ifdef shaking
    campos.y+= pow(speedfact, 3.)*shakeint*(sin(time2*2.87) + 0.85*sin(time2*4.23) + 0.65*sin(time2*7.02) + 0.35*sin(time2*11.12) + 0.1*sin(time2*15.62));
    #endif

    // Changes the camera direction accordingly to the mouse position, so that you can look around!
   	vec2 iMouse2;
   	if (iMouse.x==0. && iMouse.y==0.)
      	iMouse2 = iResolution.xy*vec2(0.5, 0.5);
   	else
      	iMouse2 = iMouse.xy; 
   
    float camAngleX = -2.*pi*(iMouse2.x/iResolution.x - 0.5);
    float camAngleY = pi*(iMouse2.y/iResolution.y - 0.5);
    if (abs(camAngleX)>pi*0.5)
       camdir = vec3(-tan(camAngleX), tan(camAngleY), 1.);
    else
       camdir = vec3(tan(camAngleX), tan(camAngleY), -1.);
       
    // At some times, the camera suddenly tilts to 180°!
    #ifdef tilt180
    float t2cs = 0.4;
    float time3 = mod(iTime, 212.);       
    camtilt2 = smoothstep(82., 82. + t2cs, time3);
    camtilt2-= smoothstep(137., 137. + t2cs, time3);
    camtilt2+= smoothstep(193., 193. + t2cs, time3);
    camtilt2-= smoothstep(211., 211. + t2cs, time3);
    #else
    camtilt2 = 0.;
    #endif
    camdir.xy*= 1. - 2.*camtilt2;
       
    // Calculates the horizontal bending of the distorded curve and then tilts the camera accordingly, but more at higher speeds
    vec3 campos2 = vec3(0., 0., -time2 - camposdist);
    campos2 = distort(campos2);
    campos2.xy*= -1.;
    #ifdef tilt
    camdir+= camposint*vec3(campos2.x - campos.x, campos2.y - campos.y, 0.);
    camtilt = campos2.x - campos.x;
    camtilt*= 0.07 + 0.41*pow(speedfact, 2.);
    #else
    camtilt = 0.;
    #endif
    
    // Sometimes jump to the parallel lanes
    #ifdef sidejumps
    float smxv = 0.81*sin(time2*0.0038) + 0.13*sin(time2*0.0138) + 0.06*sin(time2*0.0267);
    campos.x+= ssize*smoothstep(0.79, 0.813, smxv);
    campos.x-= ssize*smoothstep(-0.87, -0.893, smxv);
    float smyv = 0.82*sin((time2 - 695.)*0.0044 + 0.2) + 0.15*sin((time2 - 695.)*0.0127) + 0.03*sin((time2 - 695.)*0.0312);
    smyv*= smoothstep(25., 30., iTime);
    campos.y+= ssize*smoothstep(0.77, 0.793, smyv);
    campos.y-= ssize*smoothstep(-0.70, -0.723, smyv);
    #endif
    
    #ifdef keys
    // Pressing some keys change the field of view
    if (isKeyPressed(KEY_Z)) fov*= 1.4;
    if (isKeyPressed(KEY_U)) fov/= 1.4;
    if (isKeyPressed(KEY_H)) fov*= 2.;
    if (isKeyPressed(KEY_J)) fov/= 2.;
    if (isKeyPressed(KEY_N)) fov*= 4.;
    if (isKeyPressed(KEY_M)) fov/= 4.;
    #endif
}

// Tracing and rendering a ray
RenderData trace0(vec3 tpos, vec3 ray, float maxdist)
{
    float tx = trace(tpos, ray, maxdist);
    vec3 col;
    vec3 pos = tpos + tx*ray;
    vec3 norm;
    
    norm = getNormal(pos, normdelta);
    col = getColor(norm, pos, ray);

    // Shading
    col = col*ambientColor*ambientint + lampsShading(norm, pos, col);

    // Ambient occlusion
    #ifdef ambocc
    col*= 1. - aoint + aoint*vec3(calcAO(pos, norm));
    #endif

    // Fog
    fogd = 1.;
    #ifdef fog
    //fogdensf = 1.;
    fogdensf = clamp(-0.15 + 1.03*sin(campos.z/218.) + 0.27*sin(campos.z/66.) + 0.11*sin(campos.z/18.) , 0., 1.);
    if (fogdensf>0.)
    {
        #ifdef fognoise
        vec3 fogpos = 0.38*ray.xyz;
        fogpos.z+= 0.012*campos.z;
        float fni = (0.8 + 0.15*fogdensf)*(0.5 + 0.3*sin(campos.z/27.5) + 0.15*sin(campos.z/11.2));
        fogdensf*= ((1. - fni) + fni*noise2(fogpos));
        #endif
        float fogdens = fogdensf*fogdens0;
        fogColor = getFogColor(tpos, ray);
        fogd = clamp(exp(-pow(fogdens*tx, 2.)), 0., 1.);
    }
    col = mix (fogColor*(0.28 + 0.72*mainLampInt), col, fogd);
    #endif  

    return RenderData(col, pos, norm, tx);
}

// Main render function
vec4 render(vec2 gl_FragCoord.xy)
{   
  	vec2 uv0 = gl_FragCoord.xy / iResolution.xy; 
  	vec2 uv = uv0*2.0 - 1.0;
  	uv.x*= iResolution.x / iResolution.y;
    
    // Tilts the uv vector
    #ifdef tilt180
    camtilt*= 1. - 2.*camtilt2;
    uv = rotateVec(uv, -camtilt*camtiltf + pi*camtilt2);
    #endif

    // Main tracing
  	vec3 ray = GetCameraRayDir(uv, camdir, fov);
  	RenderData traceinf = trace0(campos, ray, maxdist);
  	vec3 col = traceinf.col;
    
    float fogd1 = fogd;
    
    // Reflections
    #ifdef reflections
    bool isSpy0 = isSpy;
    if (refFactor>0.)
    {
        float rf2;
        rf2 = refFactor*fogd;
        vec3 refray = reflect(ray, traceinf.norm);
        traceinf = trace0(traceinf.pos, refray, maxdist*0.5);
        col = mix(col, traceinf.col, rf2);    
    }
    isSpy = isSpy0;
    #endif    
    
    #ifdef spyglitches
    if (isSpy)
    {
        getSpy = false;
        RenderData traceinf2 = trace0(campos, ray, maxdist);
        float glitchint = 0.7*smoothstep(0.73, 1.02, sin(iTime*1.6) + 0.5*sin(iTime*2.9) + 0.3*sin(iTime*5.8));
        col*= 1. + 0.6*glitchint*sin(310.*uv.y - 5.*iTime);
        col+= 0.55*glitchint*vec3(hash(vec3(uv.y + 0.04*uv.x)*542.15), hash(vec3(uv.y + 0.05*uv.x)*742.56), hash(vec3(uv.y + 0.06*uv.x)*246.35))*(1. + 0.5*sin(55.*uv.y + 5.*uv.x - 32.*iTime))*(1. + 0.5*sin(315.*uv.y + 17.*iTime));
        col = mix(col, traceinf2.col, 0.5*glitchint*(1. + sin(80.*uv.y + 15.*iTime)));
    }
    #endif
    
    // Shows the crazy lights
    #ifdef crazylights
    #ifdef showcrazylights
    col+= fogd1*showCrazyLights(campos, ray, lamps[1].position, lamps[1].intensity, lamps[1].color);
    col+= fogd1*showCrazyLights(campos, ray, lamps[2].position, lamps[2].intensity, lamps[2].color);
    #endif
    #endif
    
    // Displays a speed indicator at the bottom of the screen
    #ifdef speedindic
    if  (uv0.y<spindh)
    {
        float spind = smoothstep(speedfact*0.3 + 0.03, speedfact*0.3 - 0.03, uv0.x);
        vec3 spindcol = vec3(smoothstep(0.0, 0.33, uv0.x), smoothstep(0.75, 0.33, uv0.x), 0.45*pow(smoothstep(0., spindh*0.5, uv0.y)*smoothstep(spindh, spindh*0.5, uv0.y), 10.));
        spindcol*= 0.75 + 0.25*smoothstep(0., spindh*0.5, uv0.y)*smoothstep(spindh, spindh*0.5, uv0.y);
        // (0.75 + 0.25*smoothstep(0., spindh*0.25, uv0.y)*smoothstep(spindh, spindh*0.75, uv0.y))*        
        col = mix(col, spindcol, spind*0.75) + 0.12*spindcol*spind;
    }
    #endif
    
    //col = vec3(hash(574.56*vec3(uv.x, uv.y, 1.)));
    
  	return vec4(pow(col, vec3(gamma)), 1.0);
}

// Main image function, with antialiasing
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{   
    init();
    setCamera();
    
    // Antialiasing
    #ifdef antialias
    vec4 vs = vec4(0.);
    for (aaj=0;aaj<aasamples ;aaj++)
    {
       float oy = float(aaj)*aawidth/max(float(aasamples-1), 1.);
       for (aai=0;aai<aasamples ;aai++)
       {
          float ox = float(aai)*aawidth/max(float(aasamples-1), 1.);
          vs+= render(gl_FragCoord.xy + vec2(ox, oy));
       }
    }
    gl_FragColor = vs/vec4(aasamples*aasamples);
    #else
    gl_FragColor = vec4(render(gl_FragCoord.xy));
    #endif   
}